﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="OrderDetails.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Sales.OrderDetails" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:HiddenField ID="hdOrdersID" runat="server" />
    <div class="pageheader">
        <h2>
            <i class="fa fa-cube"></i> Order Details
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Sales.aspx">Sales</a></li>
                <li class="active">Order Details</li>
            </ol>
        </div>
    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Order Details</h1><div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView ID="grdOrderDetails" runat="server" CssClass="table"
                    Width="100%" GridLines="Both" AutoGenerateColumns="false">
                    <Columns>
                        <asp:TemplateField ItemStyle-HorizontalAlign="Center" HeaderStyle-CssClass="tCenter" HeaderStyle-HorizontalAlign="Center" Visible="false">
                            <HeaderTemplate>
                                <asp:CheckBox ID="chkSelectAll" runat="server" CssClass="chkHeader" />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <asp:HiddenField runat="server" ID="hdOrdersDetailsID" Value='<%# Eval("UniqueID") %>' />
                                <asp:CheckBox ID="chkSelect" runat="server" CssClass="chkItem" Visible='<%# string.IsNullOrEmpty(Eval("DONumber").ToString()) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Product" DataField="ProductName" />
                        <asp:BoundField HeaderText="Unit Price" DataField="UnitPrice" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Qty" DataField="Quantity" />
                        <asp:BoundField HeaderText="Amount" DataField="Amount" DataFormatString="{0:0.00}" />
                        <asp:TemplateField HeaderText="DO" Visible="false">
                            <ItemTemplate>
                                <asp:PlaceHolder ID="PlaceHolder1" runat="server" Visible='<%# !string.IsNullOrEmpty(Eval("DONumber").ToString()) %>'>
                                    <asp:HyperLink ID="lnkViewDO" runat="server" Text="View DO" Target="_blank" NavigateUrl='<%# string.Format("~/Admin/Sales/ViewDO.aspx?UniqueID={0}", Eval("UniqueID").ToString()) %>' />&nbsp;/&nbsp;
                                    <asp:LinkButton ID="lnkDownloadDO" runat="server" Text="Download" CommandArgument='<%# Eval("UniqueID") %>'
                                        OnClick="lnkDownloadDO_Click" /></asp:PlaceHolder>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-altrow" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>
    <br />
    <br />
    <div class="buttonpanel">
        <%--<asp:Button ID="btnGenerateInvoice" runat="server" CssClass="btn btn-primary btn-lg" Text="Generate Invoice"
            OnClick="btnGenerateInvoice_Click" Visible="false" />
        &nbsp;
                    <asp:Button ID="btnDownLoadInvoice" runat="server" CssClass="btn btn-primary btn-lg" Text="Download Invoice"
                        OnClick="btnDownLoadInvoice_Click" Visible="false" />
        &nbsp;
                    <asp:HyperLink ID="lnkInvoice" runat="server" CssClass="btn btn-primary btn-lg" Text="View Invoice"
                        Visible="false" Target="_blank" />&nbsp;
                    <asp:Button ID="btnGenerateDO" runat="server" CssClass="btn btn-primary btn-lg" Text="Generate DO"
                        OnClick="btnGenerateDO_Click" Visible="false" OnClientClick="return CheckBoxValidation('Please select any Order Item to generate DO.');" />
        &nbsp;--%>
                    <asp:HyperLink ID="HyperLink1" runat="server" CssClass="btn btn-primary btn-lg" Text="Back"
                        NavigateUrl="~/Admin/Sales/Sales.aspx" />
    </div>

    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>


</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
</asp:Content>
